function Lge=LagrangePol(Matrix)

Dim=size(Matrix);                       %  Racunamo dimenzije matrice, u vidu vektora koji se sastoji  
n=Dim(1,1);                             %iz 2 elementa. Interesuje nas prvi element, koji predstavlja
Lge=zeros(1,n);                         %broj vrsta matrice, jer je to upravo broj nula polinoma koji 
for i=1:n                               %trazimo. Na osnovu toga formiramo vektor sa n elemenata, koji 
    Pr=[1];                             %su na pocetku nule. 
    for j=1:n                           %  Inicijalizacija privremenog polinoma.
       if (j~=i)                        %
           
          Raz=([1, (-Matrix(j,1))]/(Matrix(i,1)-Matrix(j,1)));
          
          Pr=conv(Pr,Raz);              %  Formiramo polinom koji predstavlja razlomak iz formule
       end                              %Lagranzovog polinoma. Zatim taj mnozimo sa privremenim.
    end                                 %
    Lge=Lge+Pr.*Matrix(i,2);            %  Sabiranje sa Lagranzovim polinomom koji je na pocetku 
end                                     %inicijalizovan na nulu. Ovu operaciju je moguce izvrsiti
                                        %jer dimenzija privremenog polinoma odgovara dimeniziji
                                        %Lagranzovog polinoma. 
                                                                            
                                        